---
title: JavaScript · Cloudflare Workers docs
description: The Workers platform is designed to be JavaScript standards
  compliant and web-interoperable, and supports JavaScript standards, as defined
  by TC39 (ECMAScript). Wherever possible, it uses web platform APIs, so that
  code can be reused across client and server, as well as across WinterCG
  JavaScript runtimes.
lastUpdated: 2025-03-13T11:08:22.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/workers/languages/javascript/
  md: https://developers.cloudflare.com/workers/languages/javascript/index.md
---

The Workers platform is designed to be [JavaScript standards compliant](https://ecma-international.org/publications-and-standards/standards/ecma-262/) and web-interoperable, and supports JavaScript standards, as defined by [TC39](https://tc39.es/) (ECMAScript). Wherever possible, it uses web platform APIs, so that code can be reused across client and server, as well as across [WinterCG](https://wintercg.org/) JavaScript runtimes.

Refer to [Runtime APIs](https://developers.cloudflare.com/workers/runtime-apis/) for more information on specific JavaScript APIs available in Workers.

### Resources

* [Getting Started](https://developers.cloudflare.com/workers/get-started/guide/)
* [Quickstarts](https://developers.cloudflare.com/workers/get-started/quickstarts/) – More example repos to use as a basis for your projects
* [TypeScript type definitions](https://github.com/cloudflare/workers-types)
* [JavaScript and web standard APIs](https://developers.cloudflare.com/workers/runtime-apis/web-standards/)
* [Tutorials](https://developers.cloudflare.com/workers/tutorials/)
* [Examples](https://developers.cloudflare.com/workers/examples/?languages=JavaScript)
