---
title: Malicious uploads detection · Cloudflare Web Application Firewall (WAF) docs
description: The malicious uploads detection, also called uploaded content
  scanning, is a WAF traffic detection that scans content being uploaded to your
  application.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/detections/malicious-uploads/
  md: https://developers.cloudflare.com/waf/detections/malicious-uploads/index.md
---

The malicious uploads detection, also called uploaded content scanning, is a WAF [traffic detection](https://developers.cloudflare.com/waf/concepts/#detection-versus-mitigation) that scans content being uploaded to your application.

When enabled, content scanning attempts to detect content objects, such as uploaded files, and scans them for malicious signatures like malware. The scan results, along with additional metadata, are exposed as fields available in WAF [custom rules](https://developers.cloudflare.com/waf/custom-rules/), allowing you to implement fine-grained mitigation rules.

Note

This feature is available to customers on an Enterprise plan with a paid add-on.

## How it works

Once enabled, content scanning will run for all incoming traffic, identifying [content objects](#what-is-a-content-object) automatically.

For every request with one or more detected content objects, the content scanner connects to an antivirus (AV) scanner to perform a thorough analysis of the content objects. Using the results of the scan, the WAF will populate several fields you can use in rule expressions. For example, you can create a basic rule to block requests containing malicious files, or a more complex rule where the expression matches specific file sizes, file types, or URI paths.

Cloudflare uses the same [anti-virus (AV) scanner used in Cloudflare Zero Trust](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/antivirus-scanning/) for WAF content scanning.

Note

Content scanning will not apply any mitigation actions to requests with content objects considered malicious. It only provides a signal that you can use to define your attack mitigation strategy. You must create rules — [custom rules](https://developers.cloudflare.com/waf/custom-rules/) or [rate limiting rules](https://developers.cloudflare.com/waf/rate-limiting-rules/) — to perform actions based on detected signals.

For more information on detection versus mitigation, refer to [Concepts](https://developers.cloudflare.com/waf/concepts/#detection-versus-mitigation).

## What is a content object?

A content object is any request payload detected by heuristics that does not match any of the following types: `text/html`, `text/x-shellscript`, `application/json`, `text/csv`, and `text/xml`. All other content types are considered a content object, such as the following:

* Executable files (for example, `.exe`, `.bat`, `.dll`, and `.wasm`)
* Documents (for example, `.doc`, `.docx`, `.pdf`, `.ppt`, and `.xls`)
* Compressed files (for example, `.gz`, `.zip`, and `.rar`)
* Image files (for example, `.jpg`, `.png`, `.gif`, `.webp`, and `.tif`)
* Video and audio files

Content scanning does not take the request's `Content-Type` header into account, since this header can be manipulated. If the system detects a malicious object but cannot determine its exact content type, it reports the malicious content object as having an `application/octet-stream` content type.

## Scanned content

Content scanning can check the following content objects for malicious content:

* Uploaded files in a request
* Portions of the request body for multipart requests encoded as `multipart/form-data` or `multipart/mixed`
* Specific JSON properties in the request body (containing, for example, files encoded in Base64) according to the [custom scan expressions](#custom-scan-expressions) you provide

All content objects in an incoming request will be checked, namely for requests with multiple uploaded files (for example, a submitted HTML form with several file inputs).

The content scanner will fully check content objects with a size up to 50 MB. For larger content objects, the scanner will analyze the first 50 MB and provide scan results based on that portion of the object.

Notes

* The AV scanner will not scan some particular types of files, namely the following:

  * Password-protected archives
  * Archives with more than three recursion levels
  * Archives with more than 300 files
  * PGP-encrypted files

* In rare cases, the AV scanner may time out and fail to analyze a content object. When this happens, the `cf.waf.content_scan.has_failed` field will be set to true.

## Custom scan expressions

Sometimes, you may want to specify where to find the content objects, such as when the content is a Base64-encoded string within a JSON payload. For example:

```json
{ "file": "<BASE64_ENCODED_STRING>" }
```

In these situations, configure a custom scan expression to tell the content scanner where to find the content objects. For more information, refer to [Configure a custom scan expression](https://developers.cloudflare.com/waf/detections/malicious-uploads/get-started/#4-optional-configure-a-custom-scan-expression).

For more information and additional examples of looking up fields in nested JSON payloads, refer to the [`lookup_json_string()`](https://developers.cloudflare.com/ruleset-engine/rules-language/functions/#lookup_json_string) function documentation.

Note

The content scanner will automatically decode Base64 strings.

## Content scanning fields

When content scanning is enabled, you can use the following fields in WAF rules:

| Field | Description |
| - | - |
| Has content object [`cf.waf.content_scan.has_obj`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.waf.content_scan.has_obj/) Boolean | Indicates whether the request contains at least one content object. |
| Has malicious content object [`cf.waf.content_scan.has_malicious_obj`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.waf.content_scan.has_malicious_obj/) Boolean | Indicates whether the request contains at least one malicious content object. |
| Number of malicious content objects [`cf.waf.content_scan.num_malicious_obj`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.waf.content_scan.num_malicious_obj/) Integer | The number of malicious content objects detected in the request (zero or greater). |
| Content scan has failed [`cf.waf.content_scan.has_failed`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.waf.content_scan.has_failed/) Boolean | Indicates whether the file scanner was unable to scan all the content objects detected in the request. |
| Number of content objects [`cf.waf.content_scan.num_obj`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.waf.content_scan.num_obj/) Integer | The number of content objects detected in the request (zero or greater). |
| Content object size [`cf.waf.content_scan.obj_sizes`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.waf.content_scan.obj_sizes/) Array\<Integer> | An array of file sizes in bytes, in the order the content objects were detected in the request. |
| Content object type [`cf.waf.content_scan.obj_types`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.waf.content_scan.obj_types/) Array\<String> | An array of file types in the order the content objects were detected in the request. |
| Content object result [`cf.waf.content_scan.obj_results`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.waf.content_scan.obj_results/) Array\<String> | An array of scan results in the order the content objects were detected in the request. Possible values: `clean`, `suspicious`, `infected`, and `not scanned`. |

For examples of rule expressions using these fields, refer to [Example rules](https://developers.cloudflare.com/waf/detections/malicious-uploads/example-rules/).
