---
title: Custom properties · Cloudflare Style Guide
description: We have added specific custom frontmatter properties to meet specific needs.
lastUpdated: 2025-03-11T17:12:27.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/frontmatter/custom-properties/
  md: https://developers.cloudflare.com/style-guide/frontmatter/custom-properties/index.md
---

We have added specific custom [frontmatter](https://developers.cloudflare.com/style-guide/frontmatter/) properties to meet specific needs.

## Properties

### banner

**Type:&#x20;**&#x6F;bject optional

**Description:&#x20;**&#x44;isplays a [Banner](https://developers.cloudflare.com/style-guide/frontmatter/banner/) on the current docs page.

### chatbot\_deprioritize

**Type:&#x20;**&#x62;oolean optional

**Description:&#x20;**&#x49;f true, this property will de-prioritize this page in the responses surfaced by Support AI. Helpful for pages that are historically accurate, but no longer recommended, such as [Workers Sites](https://developers.cloudflare.com/workers/configuration/sites/). Companion to the `noindex` property.

### difficulty

**Type:&#x20;**&#x75;nion optional

**Description:&#x20;**&#x44;ifficulty is displayed as a column in the [ListTutorials component](https://developers.cloudflare.com/style-guide/components/list-tutorials/).

Allowed values

* `Beginner`
* `Intermediate`
* `Advanced`

### external\_link

**Type:&#x20;**&#x73;tring optional

**Description:&#x20;**&#x50;ath to another page in our docs or elsewhere. Used to add a crosslink entry to the lefthand navigation sidebar.

### feedback

**Type:&#x20;**&#x62;oolean

**Description:&#x20;**&#x57;hether to show the FeedbackPrompt on the page, defaults to true

### hideChildren

**Type:&#x20;**&#x62;oolean optional

**Description:&#x20;**&#x52;enders this group as a single link on the sidebar, to the index page. Refer to [Sidebar](https://developers.cloudflare.com/style-guide/frontmatter/sidebar/).

### icon

**Type:&#x20;**&#x6F;bject optional

### noindex

**Type:&#x20;**&#x62;oolean optional

**Description:&#x20;**&#x49;f true, this property adds a `noindex` declaration to the page, which will tell internal / external search crawlers to ignore this page. Helpful for pages that are historically accurate, but no longer recommended, such as [Workers Sites](https://developers.cloudflare.com/workers/configuration/sites/). Companion to the `chatbot_deprioritize` property.

### pcx\_content\_type

**Type:&#x20;**&#x75;nion optional

**Description:&#x20;**&#x54;he purpose of the page, and defined through specific pages in [Content strategy](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/).

Allowed values

* `changelog`
* `changelog-entry`
* `configuration`
* `concept`
* `design-guide`
* `example`
* `faq`
* `get-started`
* `how-to`
* `integration-guide`
* `implementation-guide`
* `learning-unit`
* `navigation`
* `overview`
* `reference`
* `reference-architecture`
* `reference-architecture-diagram`
* `release-notes`
* `troubleshooting`
* `tutorial`
* `video`

### preview\_image

**Type:&#x20;**&#x73;tring optional

**Description:&#x20;**&#x41; `src` path to the image that you want to use as a custom preview image for social sharing.

### products

**Type:&#x20;**&#x61;rray

**Description:&#x20;**&#x54;he names of related products (according to their file name in `src/content/products`). Usually, these correspond to file paths, but not always, such as with `cloudflare-tunnel`

### release\_notes\_file\_name

**Type:&#x20;**&#x61;rray optional

**Description:&#x20;**&#x52;equired for the [`ProductReleaseNotes`](https://developers.cloudflare.com/style-guide/components/usage/#productreleasenotes) component.

### reviewed

**Type:&#x20;**&#x64;ate optional

**Description:&#x20;**&#x41; `YYYY-MM-DD` value that signals when the page was last explicitly reviewed from beginning to end. This is used to automatically add the [LastReviewed component](https://developers.cloudflare.com/style-guide/components/last-reviewed/). Commonly related to [tutorials](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/tutorial/) and [reference architectures](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/reference-architecture/).

### sidebar

**Type:&#x20;**&#x6F;bject

**Description:&#x20;**&#x55;sed to configure various sidebar options. Refer to [Sidebar](https://developers.cloudflare.com/style-guide/frontmatter/sidebar/).

### spotlight

**Type:&#x20;**&#x6F;bject optional

**Description:&#x20;**&#x54;hese are used to automatically add the [SpotlightAuthorDetails component](https://developers.cloudflare.com/style-guide/components/spotlight-author-details/) to the page.

### styleGuide

**Type:&#x20;**&#x6F;bject optional

**Description:&#x20;**&#x55;sed by overrides for style guide component documentation, which helps us display the [usage counts](https://developers.cloudflare.com/style-guide/components/usage/) for components directly on the component page itself.

### summary

**Type:&#x20;**&#x73;tring optional

**Description:&#x20;**&#x52;enders a summary description directly below the page title.

### tags

**Type:&#x20;**&#x61;rray optional

**Description:&#x20;**&#x41; group of related keywords relating to the purpose of the page. Refer to [Tags](https://developers.cloudflare.com/style-guide/frontmatter/tags/).
