---
title: Diagrams · Cloudflare Style Guide
description: Images that depict a process, architecture, or some other form of
  technology. These should ideally be in an SVG format because of scalability
  issues.
lastUpdated: 2025-07-15T13:59:35.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/diagrams/
  md: https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/diagrams/index.md
---

## Definition

Images that depict a process, architecture, or some other form of technology. These should ideally be in an `SVG` format because of scalability issues.

## Used in

All content types

## Overview

Diagrams explain complex topics in a compelling way and help users visualize a specific solution, process, or interaction between products.

## Template

```md
![Alt text](/link/to/image.svg "Caption to go under the image")
```

## Example

![A simple flow diagram shows interactions between important elements of the design.](https://developers.cloudflare.com/_astro/simple-flow.DifdHPUG_Z1rqtoN.webp)

## Additional information

Always try to use SVG images for diagrams. Bitmap formats like PNG and JPEG do not scale well, and often users will zoom into diagrams to explore the details.

The alt (alternative) text on diagrams is used by screen readers and is read out as part of the surrounding content. Ensure the alt text is straightforward and fits in the context of the content.

## Optimizations

When we use SVGs for diagrams, we can also optimize them via a [recurring script](https://github.com/cloudflare/cloudflare-docs/blob/production/scripts/optimize-svgs.ts) in our repo.

## Related components

* [Mermaid diagrams](https://developers.cloudflare.com/style-guide/components/mermaid/)
* [Screenshots](https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/screenshots/)
