---
title: Method types & common verbs · Cloudflare Style Guide
description: The verb examples are a small handful of commonly used verbs
  associated with a method, but you should not feel limited and only use the
  verbs in the examples.
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/api-content-strategy/method-types-and-command-verbs/
  md: https://developers.cloudflare.com/style-guide/api-content-strategy/method-types-and-command-verbs/index.md
---

The verb examples are a small handful of commonly used verbs associated with a method, but you should not feel limited and only use the verbs in the examples.

When writing the endpoint title, use the root form of the verb. For example, “Create a namespace.”

For the endpoint description, use the present tense of the verb. For example, “Creates a namespace under the given title.”

Additionally, using the method type as the verb in the title and description is okay. For example, using the method GET and including it in the description as “Gets embed code” is acceptable.

| Method | Purpose | Verb examples |
| - | - | - |
| `GET` | Retrieves a resource | Gets, Lists, Returns, Downloads |
| `POST` | Creates a resource | Creates, Watches, Inserts, Adds |
| `PUT` | Updates or creates an existing resource | Updates, Modifies, Adds |
| `PATCH` | Partially modifies an existing resource | Updates, Edits, Changes |
| `DELETE` | Removes the resource | Deletes, Removes, Cancels |
