---
title: General FAQ · Cloudflare SSL/TLS docs
description: The following provide answers to the most common questions
  associated with Cloudflare SSL/TLS certificates and settings.
lastUpdated: 2025-10-23T22:25:50.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ssl/troubleshooting/faq/
  md: https://developers.cloudflare.com/ssl/troubleshooting/faq/index.md
---

The following provide answers to the most common questions associated with Cloudflare SSL/TLS certificates and settings.

## If I have multiple Cloudflare certificates, which one is used?

Cloudflare certificates are prioritized by a combination of hostname specificity, zone specificity, and certificate type.

For more details, refer to [Certificate and hostname priority](https://developers.cloudflare.com/ssl/reference/certificate-and-hostname-priority/).

Warning

Occasionally, the Cloudflare dashboard displays a wildcard certificate with only the apex hostname listed (and does not include the wildcard symbol `*`).

This behavior occurs when all of the following conditions are true:

* The zone is on a [subdomain setup](https://developers.cloudflare.com/dns/zone-setups/subdomain-setup/).
* The certificate has a subject or SAN that is a wildcard for the zone's parent domain.

***

## Will having Cloudflare's SSL help with SEO?

Yes, Google announced that they use [HTTPS as a ranking signal for SEO](https://googleonlinesecurity.blogspot.co.uk/2014/08/https-as-ranking-signal_6.html).

For further SEO tweaks, refer to our article on [improving SEO Rankings with Cloudflare](https://developers.cloudflare.com/fundamentals/performance/improve-seo/).

***

## How long does it take for Cloudflare's SSL to activate?

If Cloudflare is your [authoritative DNS provider](https://developers.cloudflare.com/dns/zone-setups/full-setup), Universal SSL certificates typically issue within 15 minutes of domain activation at Cloudflare and do not require further customer action after domain activation.

Alternatively, if you use [Cloudflare services via `CNAME` records](https://developers.cloudflare.com/dns/zone-setups/partial-setup) set at your authoritative DNS provider, provisioning your Universal SSL certificate requires manual addition of [DNS verification records](https://developers.cloudflare.com/ssl/edge-certificates/universal-ssl/enable-universal-ssl/#partial-dns-setup) at your authoritative DNS provider. [Advanced SSL certificates](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/) also typically issue within 15 minutes.

If the Certificate Authority requires a manual review of brand, phishing, or TLD requirements, a Universal SSL certificate can take longer than 24 hours to issue.

***

## What does SSL invalid brand check mean?

Some domains are not eligible for the Universal SSL if they contain words that conflict with trademarked domains.

To resolve this issue, you can:

* Purchase an [advanced certificate](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/).
* Upload your own [custom certificate](https://developers.cloudflare.com/ssl/edge-certificates/custom-certificates/uploading/).

***

## Does Cloudflare SSL support Internationalized Domain Names (IDN)?

The double byte / IDN / punycode domains support for Cloudflare edge certificates depends on the [certificate authority (CA)](https://developers.cloudflare.com/ssl/reference/certificate-authorities). Google Trust Services does not support punycode domains as mentioned in the [certificate authorities limitations](https://developers.cloudflare.com/ssl/reference/certificate-authorities/#limitations-1).

***

## How do I redirect all visitors to HTTPS/SSL?

Refer to [Encrypt all visitor traffic](https://developers.cloudflare.com/ssl/edge-certificates/encrypt-visitor-traffic/).

***

## Does SSL work for hosting partners?

A free Universal SSL certificate is available for all new Cloudflare domains added via a hosting partner using both [full](https://developers.cloudflare.com/dns/zone-setups/full-setup/) and [partial setups](https://developers.cloudflare.com/dns/zone-setups/partial-setup/).

For more details, refer to [Enable Universal SSL certificates](https://developers.cloudflare.com/ssl/edge-certificates/universal-ssl/enable-universal-ssl/).

Note

For domains added to Cloudflare prior to December 9, 2016, the hosting partner must delete and re-add the domain to Cloudflare to provision the SSL certificate.

***

## Are Cloudflare SSL certificates shared?

No. Cloudflare SSL/TLS certificates are not shared across domains nor across customers.

***

## Why do I see a Cloudflare certificate when an SSL certificate is installed at my website?

Cloudflare must decrypt traffic in order to cache and filter malicious traffic. Cloudflare either re-encrypts traffic or sends plain text traffic to the origin web server depending on your domain's [encryption mode](https://developers.cloudflare.com/ssl/origin-configuration/ssl-modes/).

***

## I want Cloudflare to use an SSL certificate that I purchased elsewhere.

Domains on Business and Enterprise plans can upload a [Custom SSL certificate](https://developers.cloudflare.com/ssl/edge-certificates/custom-certificates).

***

## Does enabling Cloudflare affect PayPal's TLS 1.2 requirement?

No. Since Cloudflare does not proxy connections made directly to `paypal.com`, enabling Cloudflare for your domain does not affect how TLS connections are made.

However, note that PayPal IPN (Instant Payment Notification) might not support [TLS version 1.3](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/tls-13/) if you have it enabled on your zone. If you are encountering issues with PayPal IPN when the traffic is proxied by Cloudflare, try setting the [Minimum TLS version](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/minimum-tls/) to `1.2`.

***

## Does Cloudflare support TLS client authentication?

Yes. For more details, refer to our documentation on [Mutual TLS authentication](https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/access-integrations/mutual-tls-authentication/).

***

## How do I obtain an SSL certificate for customers on partial (CNAME) setup?

A [partial DNS setup](https://developers.cloudflare.com/dns/zone-setups/partial-setup/) requires additional steps to provision and validate an SSL certificate.

For more details, refer to [Enable Universal SSL](https://developers.cloudflare.com/ssl/edge-certificates/universal-ssl/enable-universal-ssl#partial-dns-setup).

***

## Can I use Certificate Pinning?

No. Multiple industry leaders — including [Digicert](https://www.digicert.com/blog/certificate-pinning-what-is-certificate-pinning) and [Mozilla](https://developer.mozilla.org/en-US/docs/Web/HTTP/Public_Key_Pinning) — have discouraged certificate pinning because of security concerns.

For a safer alternative, use [Certificate Transparency Monitoring](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/certificate-transparency-monitoring/).

Refer to [Certificate pinning](https://developers.cloudflare.com/ssl/reference/certificate-pinning/) for more details.

***

## Where can I learn more about SSL?

To learn more about SSL, go to the [Cloudflare Learning Center](https://www.cloudflare.com/learning/ssl/what-is-ssl/).

***

## Redsys is not working with my Let's Encrypt Certificate.

The Let's Encrypt Certificate Authority and SNI are not currently supported by Redsys.

We recommend one of the following options:

* Change the Universal Certificate Authority to a different CA.
* Add an [advanced certificate](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/) or [custom certificate](https://developers.cloudflare.com/ssl/edge-certificates/custom-certificates/) using a different CA.

***

## What is the HTTP version used for OCSP?

Our OCSP implementation uses HTTP/1.1 by default for plain HTTP connections.

For HTTPS connections, the client automatically attempts to use HTTP/2 if the server supports it through the TLS ALPN (Application-Layer Protocol Negotiation) extension. If HTTP/2 is not available or supported by the server, it will fall back to HTTP/1.1.
