---
title: Features and plans · Cloudflare SSL/TLS docs
description: Review information on all Cloudflare SSL/TLS features and their availability.
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ssl/reference/all-features/
  md: https://developers.cloudflare.com/ssl/reference/all-features/index.md
---

Cloudflare provides the following features for different [plans](https://www.cloudflare.com/plans/).

## Features

### Advanced Certificates

**Link:** [Advanced Certificates](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)

**Feature availability**

* **Free:** Paid add-on
* **Pro:** Paid add-on
* **Business:** Paid add-on
* **Enterprise:** Paid add-on

### Authenticated origin pull

**Link:** [Authenticated origin pull](https://developers.cloudflare.com/ssl/origin-configuration/authenticated-origin-pull/)

**Feature availability**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Backup Certificates

**Link:** [Backup Certificates](https://developers.cloudflare.com/ssl/edge-certificates/backup-certificates/)

**Feature availability**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Can opt out?**

Enterprise-only

* **Free:** No
* **Pro:** No
* **Business:** No
* **Enterprise:** Yes

### Custom Certificates

**Link:** [Custom Certificates](https://developers.cloudflare.com/ssl/edge-certificates/custom-certificates/)

**Feature availability**

* **Free:** No
* **Pro:** No
* **Business:** Yes
* **Enterprise:** Yes

**Certificates included**

* **Free:** 0
* **Pro:** 0
* **Business:** 1 Modern and 1 Legacy
* **Enterprise:** 1 Modern (can purchase more) and 1 Legacy (can purchase more)

### Always Use HTTPS

**Link:** [Always Use HTTPS](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/always-use-https/)

**Feature availability**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Automatic HTTPS Rewrites

**Link:** [Automatic HTTPS Rewrites](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/automatic-https-rewrites/)

**Feature availability**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Certificate Transparency Monitoring

**Link:** [Certificate Transparency Monitoring](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/certificate-transparency-monitoring/)

**Feature availability**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Email Recipients**

* **Free:** All account members
* **Pro:** All account members
* **Business:** Specified email addresses
* **Enterprise:** Specified email addresses

### Opportunistic Encryption

**Link:** [Opportunistic Encryption](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/opportunistic-encryption/)

**Feature availability**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### HTTP Strict Transport Security

**Link:** [HTTP Strict Transport Security](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/http-strict-transport-security/)

**Feature availability**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### TLS 1.3

**Link:** [TLS 1.3](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/tls-13/)

**Feature availability**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Minimum TLS Version

**Link:** [Minimum TLS Version](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/minimum-tls/)

**Feature availability**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Per-hostname**

* **Free:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Pro:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Business:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Enterprise:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)

### Certificate Signing Requests

**Link:** [Certificate Signing Requests](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/certificate-signing-requests/)

**Feature availability**

* **Free:** No
* **Pro:** No
* **Business:** No
* **Enterprise:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)

### Custom Hostnames

**Link:** [Custom Hostnames](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/plans/)

**Feature availability**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Contact your account team

**Hostnames included**

Varies

* **Free:** 100
* **Pro:** 100
* **Business:** 100
* **Enterprise:** Custom

**Max hostnames**

* **Free:** 50,000
* **Pro:** 50,000
* **Business:** 50,000
* **Enterprise:** Unlimited, but contact sales if using over 50,000.

**Price per additional hostname**

* **Free:** $0.10
* **Pro:** $0.10
* **Business:** $0.10
* **Enterprise:** Custom pricing

**[Custom analytics](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/hostname-analytics/)**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**[Custom origin](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/start/advanced-settings/custom-origin/)**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**[SNI Rewrite for Custom Origin](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/start/advanced-settings/custom-origin/#sni-rewrites)**

* **Free:** No
* **Pro:** No
* **Business:** No
* **Enterprise:** Contact your account team

**[Custom certificates](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/security/certificate-management/custom-certificates/)**

* **Free:** No
* **Pro:** No
* **Business:** No
* **Enterprise:** Yes

**[CSR support](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/security/certificate-management/custom-certificates/certificate-signing-requests/)**

* **Free:** No
* **Pro:** No
* **Business:** No
* **Enterprise:** Yes

**[Selectable CA](https://developers.cloudflare.com/ssl/reference/certificate-authorities/)**

* **Free:** No
* **Pro:** No
* **Business:** No
* **Enterprise:** Yes

**Wildcard custom hostnames**

* **Free:** No
* **Pro:** No
* **Business:** No
* **Enterprise:** Yes

**Non-SNI support for SaaS zone**

* **Free:** No
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**[mTLS support](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/security/certificate-management/enforce-mtls/)**

* **Free:** No
* **Pro:** No
* **Business:** No
* **Enterprise:** Yes

**[WAF for SaaS](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/security/waf-for-saas/)**

* **Free:** WAF rules with current zone plan
* **Pro:** WAF rules with current zone plan
* **Business:** WAF rules with current zone plan
* **Enterprise:** Create and apply custom firewall rulesets.

**[Apex proxying/BYOIP](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/start/advanced-settings/apex-proxying/)**

* **Free:** No
* **Pro:** No
* **Business:** No
* **Enterprise:** Paid add-on

**[Custom metadata](https://developers.cloudflare.com/cloudflare-for-platforms/cloudflare-for-saas/domain-support/custom-metadata/)**

* **Free:** No
* **Pro:** No
* **Business:** No
* **Enterprise:** Paid add-on

### Custom origin trust store

**Link:** [Custom origin trust store](https://developers.cloudflare.com/ssl/origin-configuration/custom-origin-trust-store/)

**Feature availability**

* **Free:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Pro:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Business:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Enterprise:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)

### SSL/TLS encryption mode

**Link:** [SSL/TLS encryption mode](https://developers.cloudflare.com/ssl/origin-configuration/ssl-modes/)

**Feature availability**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Strict (SSL-Only Origin Pull)**

Enterprise-only

* **Free:** No
* **Pro:** No
* **Business:** No
* **Enterprise:** Yes

### Keyless SSL

**Link:** [Keyless SSL](https://developers.cloudflare.com/ssl/keyless-ssl/)

**Feature availability**

* **Free:** No
* **Pro:** No
* **Business:** No
* **Enterprise:** Paid add-on

### Origin certificates

**Link:** [Origin certificates](https://developers.cloudflare.com/ssl/origin-configuration/origin-ca/)

**Feature availability**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Staging environment

**Link:** [Staging environment](https://developers.cloudflare.com/ssl/edge-certificates/staging-environment/)

**Feature availability**

* **Free:** No
* **Pro:** No
* **Business:** No
* **Enterprise:** Yes (open beta)

### SSL/TLS Recommender

**Link:** [SSL/TLS Recommender](https://developers.cloudflare.com/ssl/origin-configuration/ssl-tls-recommender/)

**Feature availability**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Custom cipher suites

**Link:** [Custom cipher suites](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/cipher-suites/customize-cipher-suites/)

**Feature availability**

* **Free:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Pro:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Business:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Enterprise:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)

### Total TLS

**Link:** [Total TLS](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/total-tls/)

**Feature availability**

* **Free:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Pro:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Business:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Enterprise:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)

### Delegated DCV

**Link:** [Delegated DCV](https://developers.cloudflare.com/ssl/edge-certificates/changing-dcv-method/methods/delegated-dcv/)

**Feature availability**

* **Free:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Pro:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Business:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)
* **Enterprise:** Included with [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/)

### Universal Certificates

**Link:** [Universal Certificates](https://developers.cloudflare.com/ssl/edge-certificates/universal-ssl/)

**Feature availability**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

### Client Certificates

**Link:** [Client Certificates](https://developers.cloudflare.com/ssl/client-certificates/)

**Feature availability**

* **Free:** Yes
* **Pro:** Yes
* **Business:** Yes
* **Enterprise:** Yes

**Client Certificates included, issued by a Cloudflare Managed CA**

* **Free:** 100
* **Pro:** 100
* **Business:** 100
* **Enterprise:** 100 (default), but can allocate more quota.

**[Bring your own CA](https://developers.cloudflare.com/ssl/client-certificates/byo-ca/)**

* **Free:** No
* **Pro:** No
* **Business:** No
* **Enterprise:** Yes
