---
title: Get started · Cloudflare Smart Shield docs
description: Smart Shield is available to all customers as an opt-in configuration.
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/smart-shield/get-started/
  md: https://developers.cloudflare.com/smart-shield/get-started/index.md
---

Smart Shield is available to all customers as an opt-in configuration.

## Before you begin

* You should have a Cloudflare account and [onboard your domain](https://developers.cloudflare.com/fundamentals/manage-domains/add-site/).
* Also make sure the relevant DNS records are set to [proxied](https://developers.cloudflare.com/dns/proxy-status/).

## Steps

1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/), and select your account and domain.
2. Go to **Speed** > **Smart Shield**.
3. (Optional) Explore the different [available packages](#packages-and-availability).
4. Select **Get started for free** or choose a different package and select **Continue** to proceed to the guided onboarding flow.

Access analytics and get insights through the [Observatory](https://developers.cloudflare.com/speed/observatory/) dashboard.

## Packages and availability

### Smart Shield

* Includes [Smart Tiered Cache](https://developers.cloudflare.com/smart-shield/configuration/smart-tiered-cache/) and [connection reuse](https://developers.cloudflare.com/smart-shield/concepts/connection-reuse/).
* Pro, Business, and Enterprise customers also have access to [Health Checks](https://developers.cloudflare.com/smart-shield/configuration/health-checks/).

### Smart Shield + Argo

* Includes [Smart Tiered Cache](https://developers.cloudflare.com/smart-shield/configuration/smart-tiered-cache/), [connection reuse](https://developers.cloudflare.com/smart-shield/concepts/connection-reuse/), and [Argo Smart Routing](https://developers.cloudflare.com/smart-shield/configuration/argo/).
* Pro, Business, and Enterprise customers also have access to [Health Checks](https://developers.cloudflare.com/smart-shield/configuration/health-checks/).

### Smart Shield Advanced

* Includes [Smart Tiered Cache](https://developers.cloudflare.com/smart-shield/configuration/smart-tiered-cache/), [connection reuse](https://developers.cloudflare.com/smart-shield/concepts/connection-reuse/), [Argo Smart Routing](https://developers.cloudflare.com/smart-shield/configuration/argo/), and additional caching customization with [Regional Tiered Cache](https://developers.cloudflare.com/smart-shield/configuration/regional-tiered-cache/) and [Cache Reserve](https://developers.cloudflare.com/smart-shield/configuration/cache-reserve/).
* Pro, Business, and Enterprise customers also have access to [Health Checks](https://developers.cloudflare.com/smart-shield/configuration/health-checks/).

## Further reading

* [Network diagram](https://developers.cloudflare.com/smart-shield/concepts/network-diagram/)
* [Connection reuse](https://developers.cloudflare.com/smart-shield/concepts/connection-reuse/)
