---
title: http.response.headers.values · Cloudflare Ruleset Engine docs
description: The values of the headers in the HTTP response.
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.response.headers.values/
  md: https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.response.headers.values/index.md
---

# http.response.headers.values

`http.response.headers.values` Array\<String>

The values of the headers in the HTTP response.

The values are not pre-processed and retain the original case used in the response.

The order of header values is not guaranteed but will match [`http.response.headers.names`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.response.headers.names/).

Duplicate headers are listed multiple times.

* **Decoding**: No decoding performed
* **Whitespace**: Preserved
* **Non-ASCII**: Preserved

**Note**: The availability of HTTP response fields depends on the exact Cloudflare feature and your Cloudflare plan.

Example value:

```txt
Example 1: ["application/json"]
Example 2: ["This header value is longer than 10 bytes"]
```

Example usage:

```txt
# Example 1: Check for specific header value.
any(http.response.headers.values[*] == "application/json")


# Example 2: Match requests according to the specified operator and the length/size entered for the header value.
any(len(http.response.headers.values[*])[*] gt 10)
```

Categories:

* Response
* Headers
