---
title: Phases list · Cloudflare Ruleset Engine docs
description: The following tables list the phases of Cloudflare products powered
  by the Ruleset Engine, in the order those phases are executed. Some products
  such as the Cloudflare Web Application Firewall have more than one associated
  phase.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ruleset-engine/reference/phases-list/
  md: https://developers.cloudflare.com/ruleset-engine/reference/phases-list/index.md
---

The following tables list the [phases](https://developers.cloudflare.com/ruleset-engine/about/phases/) of Cloudflare products powered by the Ruleset Engine, in the order those phases are executed. Some products such as the Cloudflare Web Application Firewall have more than one associated phase.

## Network layer

[Network-layer](https://www.cloudflare.com/learning/ddos/glossary/open-systems-interconnection-model-osi/) phases apply to packets received on the Cloudflare global network.

| Phase name | Used in product/feature |
| - | - |
| `ddos_l4` | [Network-layer DDoS Attack Protection](https://developers.cloudflare.com/ddos-protection/managed-rulesets/network/network-overrides/configure-api/) |
| `magic_transit` | [Magic Firewall](https://developers.cloudflare.com/magic-firewall/how-to/add-rules/) |
| `magic_transit_managed` | [Magic Firewall managed rulesets](https://developers.cloudflare.com/magic-firewall/how-to/enable-managed-rulesets/) |
| `magic_transit_ratelimit` | [Magic Firewall rate limiting rules](https://developers.cloudflare.com/magic-firewall/how-to/create-rate-limiting-rules/) |
| `magic_transit_ids_managed` | [Magic Firewall Intrusion Detection System (IDS)](https://developers.cloudflare.com/magic-firewall/about/ids/) |

## Application layer

[Application-layer](https://www.cloudflare.com/learning/ddos/what-is-layer-7/) phases apply to requests received on the Cloudflare global network.

### Request phases

The phases execute in the order they appear in the table.

| Phase name | Used in product/feature |
| - | - |
| `http_request_sanitize` | [URL normalization](https://developers.cloudflare.com/rules/normalization/) |
| `http_request_dynamic_redirect` | [Single Redirects](https://developers.cloudflare.com/rules/url-forwarding/single-redirects/) |
| `http_request_transform` | [URL Rewrite Rules](https://developers.cloudflare.com/rules/transform/url-rewrite/) |
| *N/A* (internal phase) | [Waiting Room Rules](https://developers.cloudflare.com/waiting-room/additional-options/waiting-room-rules/) |
| `http_request_api_gateway_early`\* | [API Shield](https://developers.cloudflare.com/api-shield/) |
| `http_config_settings` | [Configuration Rules](https://developers.cloudflare.com/rules/configuration-rules/) |
| `http_request_origin` | [Origin Rules](https://developers.cloudflare.com/rules/origin-rules/) |
| `ddos_l7`\* | [HTTP DDoS Attack Protection](https://developers.cloudflare.com/ddos-protection/managed-rulesets/http/) |
| `http_request_firewall_custom` | [Custom rules (Web Application Firewall)](https://developers.cloudflare.com/waf/custom-rules/) |
| `http_ratelimit` | [Rate limiting rules (WAF)](https://developers.cloudflare.com/waf/rate-limiting-rules/) |
| `http_request_api_gateway_late` | [API Shield](https://developers.cloudflare.com/api-shield/) |
| `http_request_firewall_managed` | [WAF Managed Rules](https://developers.cloudflare.com/waf/managed-rules/) |
| `http_request_sbfm` | [Super Bot Fight Mode](https://developers.cloudflare.com/bots/get-started/super-bot-fight-mode/) |
| *N/A* (internal phase) | [Cloudflare Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/) |
| `http_request_redirect` | [Bulk Redirects](https://developers.cloudflare.com/rules/url-forwarding/bulk-redirects/) |
| *N/A* (internal phase) | [Managed Transforms](https://developers.cloudflare.com/rules/transform/managed-transforms/) |
| `http_request_late_transform` | [Request Header Transform Rules](https://developers.cloudflare.com/rules/transform/request-header-modification/) |
| `http_request_cache_settings` | [Cache Rules](https://developers.cloudflare.com/cache/how-to/cache-rules/) |
| `http_request_snippets` | [Snippets](https://developers.cloudflare.com/rules/snippets/) |
| `http_request_cloud_connector` | [Cloud Connector](https://developers.cloudflare.com/rules/cloud-connector/) |

\* *This phase is for configuration purposes only — the corresponding rules will not be executed at this stage in the request handling process.*

Change notice for Super Bot Fight Mode rulesets

Updating Super Bot Fight Mode rules via the Rulesets API is no longer supported and may cause unexpected behavior if you do so.

### Response phases

The phases execute in the order they appear in the table.

| Phase name | Used in product/feature |
| - | - |
| `http_custom_errors` | [Custom Errors](https://developers.cloudflare.com/rules/custom-errors/) |
| *N/A* (internal phase) | [Managed Transforms](https://developers.cloudflare.com/rules/transform/managed-transforms/) |
| `http_response_headers_transform` | [Response Header Transform Rules](https://developers.cloudflare.com/rules/transform/response-header-modification/) |
| `http_ratelimit` | [Rate limiting rules](https://developers.cloudflare.com/waf/rate-limiting-rules/) (when they use response information) |
| `http_response_compression` | [Compression Rules](https://developers.cloudflare.com/rules/compression-rules/) |
| `http_response_firewall_managed` | [Cloudflare Sensitive Data Detection](https://developers.cloudflare.com/waf/managed-rules/) (Data Loss Prevention) |
| `http_log_custom_fields` | [Logpush custom fields](https://developers.cloudflare.com/logs/logpush/logpush-job/custom-fields/) |
