---
title: Single Redirects settings · Cloudflare Rules docs
description: The following sections describe the settings of redirect rules to
  configure static and dynamic URL redirects.
lastUpdated: 2025-09-11T15:31:26.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/url-forwarding/single-redirects/settings/
  md: https://developers.cloudflare.com/rules/url-forwarding/single-redirects/settings/index.md
---

The following sections describe the settings of redirect rules to configure static and dynamic URL redirects.

## Wildcard URL Redirect

Performs a URL redirect using [wildcard patterns](https://developers.cloudflare.com/ruleset-engine/rules-language/operators/#wildcard-matching) to match multiple requests. This method simplifies defining source and target URL patterns without needing complex expressions.

A wildcard URL redirect has the following configuration parameters:

* **Request URL**: Enter the [wildcard pattern](https://developers.cloudflare.com/ruleset-engine/rules-language/operators/#wildcard-matching) using the asterisk (`*`) character to match multiple requests. For example, `https://*.example.com/files/*`.

* **Target URL**: Enter the target URL, which can be static (for example, `https://example.com`) or dynamic (for example, `https://example.com/${1}/files/${2}`). Use [wildcard replacement](https://developers.cloudflare.com/ruleset-engine/rules-language/functions/#wildcard_replace) like `${1}`, `${2}`, etc., to define dynamic targets.

* **Status code**: The HTTP status code of the redirect response (*301* by default). Must be one of the following: *301* (Moved permanently), *302* (Found, also known as Moved temporarily), *307* (Temporary redirect), or *308* (Permanent redirect).

* **Preserve query string**: Whether to preserve the query string when redirecting (disabled by default).

## Static URL redirect

Performs a static URL redirect with a given HTTP status code and optionally preserves the query string.

A static URL redirect has the following configuration parameters:

* **URL**: A literal string that will be used in the `Location` HTTP header returned in the redirect response.

* **Status code**: The HTTP status code of the redirect response (*301* by default). Must be one of the following: *301* (Moved permanently), *302* (Found, also known as Moved temporarily), *307* (Temporary redirect), or *308* (Permanent redirect).

* **Preserve query string**: Whether to preserve the query string when redirecting (disabled by default).

API information

The full syntax of the `"action_parameters"` field for a redirect rule performing a static URL redirect is the following:

```json
"action_parameters": {
  "from_value": {
    "target_url": {
      "value": "<STATIC_URL_VALUE>"
    },
    "status_code": <STATUS_CODE>,
    "preserve_query_string": <BOOLEAN_VALUE>
  }
}
```

The only required parameter is `<STATIC_URL_VALUE>`.

The optional parameters can have the following values:

* `"status_code"` (integer): `301` (Moved permanently), `302` (Found, also known as Moved temporarily), `307` (Temporary redirect), or `308` (Permanent redirect).
* `"preserve_query_string"` (boolean): `true` or `false`.

## Dynamic URL redirect

Performs a dynamic URL redirect, where the target URL is determined by an expression. You can configure the redirect HTTP status code and whether to preserve the query string when redirecting.

A dynamic URL redirect has the following configuration parameters:

* **Expression**: An [expression](https://developers.cloudflare.com/ruleset-engine/rules-language/expressions/) that defines the target URL of the redirect. The result of evaluating this expression will be used in the `Location` HTTP header returned in the redirect response. Refer to the [fields](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/) and [functions](https://developers.cloudflare.com/ruleset-engine/rules-language/functions/) you can use in expressions.

* **Status code**: The HTTP status code of the redirect response (*301* by default). Must be one of the following: *301* (Moved permanently), *302* (Found, also known as Moved temporarily), *307* (Temporary redirect), or *308* (Permanent redirect).

* **Preserve query string**: Whether to preserve the query string when redirecting (disabled by default).

API information

The full syntax of the `"action_parameters"` field for a redirect rule performing a dynamic URL redirect is the following:

```json
"action_parameters": {
  "from_value": {
    "target_url": {
      "expression": "<DYNAMIC_URL_EXPRESSION>"
    },
    "status_code": <STATUS_CODE>,
    "preserve_query_string": <BOOLEAN_VALUE>
  }
}
```

The only required parameter is `<DYNAMIC_URL_EXPRESSION>`.

The optional parameters can have the following values:

* `"status_code"` (integer): `301` (Moved permanently), `302` (Found, also known as Moved temporarily), `307` (Temporary redirect), or `308` (Permanent redirect).
* `"preserve_query_string"` (boolean): `true` or `false`.
