---
title: Next steps · Cloudflare Learning Paths
description: Your load balancer should be receiving production traffic (and you
  can confirm this by reviewing the analytics).
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/load-balancing/setup/next-steps/
  md: https://developers.cloudflare.com/learning-paths/load-balancing/setup/next-steps/index.md
---

Your load balancer should be receiving production traffic (and you can confirm this by reviewing the [analytics](https://developers.cloudflare.com/load-balancing/reference/load-balancing-analytics/)).

Though your product is officially set up, you may want to consider the following suggestions.

## Usage-based notifications

Since this is a service with [usage-based billing](https://developers.cloudflare.com/billing/usage-based-billing/), Cloudflare recommends that you set up usage-based billing notifications to avoid unexpected bills.

To set up those notifications:

1. In the Cloudflare dashboard, go to the **Notifications** page.

   [Go to **Notifications**](https://dash.cloudflare.com/?to=/:account/notifications)

2. On **Alert Type** of **Usage Based Billing**, click **Select**.

3. Fill out the following information:

   * **Name**
   * **Product**
   * **Notification limit** (exact metric will vary based on product)
   * **Notification email**

   Note

   Some plans also have access to alerts through [PagerDuty](https://developers.cloudflare.com/notifications/get-started/configure-pagerduty/) and [Webhooks](https://developers.cloudflare.com/notifications/get-started/configure-webhooks/).

4. Select **Save**.

## Additional configuration options

You may want to further customize how your load balancer routes traffic or integrate your load balancer with other Cloudflare products:

* [Additional DNS records](https://developers.cloudflare.com/load-balancing/additional-options/additional-dns-records/)
* [Cloudflare Tunnel (published applications)](https://developers.cloudflare.com/load-balancing/additional-options/cloudflare-tunnel/)
* [Spectrum](https://developers.cloudflare.com/load-balancing/additional-options/spectrum/)
* [Perform planned maintenance](https://developers.cloudflare.com/load-balancing/additional-options/planned-maintenance/)
* [Load Balancing with the China Network](https://developers.cloudflare.com/load-balancing/additional-options/load-balancing-china/)
* [Load shedding](https://developers.cloudflare.com/load-balancing/additional-options/load-shedding/)
* [Override HTTP Host headers](https://developers.cloudflare.com/load-balancing/additional-options/override-http-host-headers/)
* [Custom load balancing rules](https://developers.cloudflare.com/load-balancing/additional-options/load-balancing-rules/)
* [Integrate with PagerDuty](https://developers.cloudflare.com/load-balancing/additional-options/pagerduty-integration/)
