---
title: Retract settings · Cloudflare Email Security (formerly Area 1) docs
description: When you are using an API setup for Email Security, you cannot
  prevent mail from reaching a recipient's mailbox.
lastUpdated: 2024-10-23T16:55:34.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/email-security/email-configuration/retract-settings/
  md: https://developers.cloudflare.com/email-security/email-configuration/retract-settings/index.md
---

When you are using an [API setup](https://developers.cloudflare.com/email-security/deployment/api/) for Email Security, you cannot prevent mail from reaching a recipient's mailbox.

However — so long as you also have [journaling](https://developers.cloudflare.com/email-security/deployment/api/setup/#journaling-setup), [BCC](https://developers.cloudflare.com/email-security/deployment/api/setup/#bcc-setup) or [MS Graph](https://developers.cloudflare.com/email-security/deployment/api/setup/office365-graph-api/) configured — you can set up message retraction to take post-delivery actions against suspicious messages. These retractions happen through API integrations with Microsoft 365 and Google Workspaces (Gmail).

## Retraction options

Once you set up retraction, you can retract messages manually or set up automatic retractions to move messages matching certain dispositions to specific folders within a user’s mailbox. You can also enable Post Delivery Response and Phish Submission Response to re-evaluate messages previously delivered against new information gathered by Email Security. Scanned emails that were previously delivered and now match this new phishing information will be retracted.

Refer to [Gmail](https://developers.cloudflare.com/email-security/deployment/api/setup/gsuite-bcc-setup/add-retraction/) and [Office 365](https://developers.cloudflare.com/email-security/email-configuration/retract-settings/office365-retraction/) guides for detailed information regarding these options.

## Retraction metrics

Setting up retraction also gives you access to metrics for this feature. After logging in to your [Email Security dashboard](https://horizon.area1security.com), search for the **Retractions** card. Metrics for retractions include information such as:

* **Total retractions**: Displays the total amount of retractions performed.

* **Success**: Shows the percentage of messages Email Security was able to find and retract successfully.

* **Fail**: Displays the percentage of messages Email Security was not successfully able to retract. Reasons for failure include:

  * The user has already deleted or marked the message as junk, either manually or via a mailbox filter.
  * The specific copy of the message being retracted was sent to a distribution list address that may not exist as a mailbox, and so the retraction will fail. Separate copies of the message that are sent to each member of that distribution list will be retracted.
  * The retraction is not, or is no longer, authorized.

* **Unread/Read**: Refers to the state of the message at the time it was retracted. For automated retractions, Email Security tries to perform retraction as quickly as possible so the user has no time to see or open the message. Manual retraction might happen at a later time, and so the messages are more likely to have already been read.

* **Auto/Manual**: Refers to the percentage of messages retracted through the automatic/manual modes.

Selecting **View details** will perform a search for retracted emails for the selected time interval.
