---
title: Private networks · Cloudflare Zero Trust docs
description: With Cloudflare Zero Trust, you can connect private networks and
  the services running in those networks to Cloudflare's global network. This
  involves installing a connector on the private network, and then setting up
  routes which define the IP addresses available in that environment. Unlike
  published applications, private network routes can expose both HTTP and
  non-HTTP resources.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/
  md: https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/index.md
---

With Cloudflare Zero Trust, you can connect private networks and the services running in those networks to Cloudflare's global network. This involves installing a [connector](#connectors) on the private network, and then [setting up routes](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/get-started/create-remote-tunnel/#2b-connect-a-network) which define the IP addresses available in that environment. Unlike [published applications](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/routing-to-tunnel/), private network routes can expose both HTTP and non-HTTP resources.

To reach private network IPs, end users must connect their device to Cloudflare and enroll in your Zero Trust organization. The most common method is to install the [WARP client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/) on their device, or you can onboard their network traffic to Cloudflare using our [WARP Connector](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/warp-connector/) or [Magic WAN](https://developers.cloudflare.com/magic-wan/zero-trust/cloudflare-tunnel/).

Administrators can optionally set [Gateway network policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/network-policies/) to control access to services based on user identity and device posture.

## Connectors

Here are the different ways you can connect your private network to Cloudflare:

* [**cloudflared**](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/cloudflared/) installs on a server in your private network to create a secure, outbound tunnel to Cloudflare. Cloudflare Tunnel using `cloudflared` only proxies traffic initiated from a user to a server. Any service or application running behind the tunnel will use the server's default routing table for server-initiated connectivity.
* [**WARP-to-WARP**](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/warp-to-warp/) uses the [Cloudflare WARP client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/) to establish peer-to-peer connectivity between two or more devices. Each device running WARP can access services on any other device running WARP via an assigned virtual IP address.
* [**WARP Connector**](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/warp-connector/) installs on a Linux server in your private network to establish site-to-site, bidirectional, and mesh networking connectivity. The WARP Connector acts as a subnet router to relay client-initiated and server-initiated traffic between all devices on a private network and Cloudflare.
* [**Magic WAN**](https://developers.cloudflare.com/magic-wan/) relies on configuring legacy networking equipment to establish anycast GRE or IPsec tunnels between an entire network location and Cloudflare.
