---
title: Cloud and SaaS findings · Cloudflare Zero Trust docs
description: Cloudflare's API-driven Cloud Access Security Broker (CASB)
  integrates with SaaS applications and cloud environments to scan for
  misconfigurations, unauthorized user activity, shadow IT, and other data
  security issues that can occur after a user has successfully logged in.
lastUpdated: 2025-10-24T15:44:40.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/cloud-and-saas-findings/
  md: https://developers.cloudflare.com/cloudflare-one/cloud-and-saas-findings/index.md
---

Availability

Available for all Zero Trust users.

Free users can configure up to two CASB integrations. You must upgrade to an Enterprise plan to view the details of a finding instance.

Cloudflare's API-driven [Cloud Access Security Broker](https://www.cloudflare.com/learning/access-management/what-is-a-casb/) (CASB) integrates with SaaS applications and cloud environments to scan for misconfigurations, unauthorized user activity, [shadow IT](https://www.cloudflare.com/learning/access-management/what-is-shadow-it/), and other data security issues that can occur after a user has successfully logged in.

For a list of available findings, refer to [Cloud and SaaS integrations](https://developers.cloudflare.com/cloudflare-one/integrations/cloud-and-saas/).

## Manage CASB integrations

When you integrate a third-party SaaS application or cloud environment with Cloudflare CASB, you allow CASB to make API calls to its endpoint and read relevant data on your behalf. The CASB integration permissions are read-only and follow the least privileged model. In other words, only the minimum access required to perform a scan is granted.

### Prerequisites

Before you can integrate a SaaS application or cloud environment with CASB, your account with that integration must meet certain requirements. Refer to the SaaS application or cloud environment's [integration guide](https://developers.cloudflare.com/cloudflare-one/integrations/cloud-and-saas/) to learn more about the prerequisites and permissions.

### Add an integration

1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **CASB** > **Integrations**.
2. Select **Connect an integration** or **Add integration**.
3. Browse the available integrations and select the application you would like to add.
4. Follow the step-by-step integration instructions in the UI.
5. To run your first scan, select **Save integration**.

After the first scan, CASB will automatically scan your SaaS application or cloud environment on a frequent basis to keep up with any changes. Scan intervals will vary due to each application having their own set of requirements, but the frequency is typically between every 1 hour and every 24 hours.

Once CASB detects at least one finding, you can [view and manage your findings](https://developers.cloudflare.com/cloudflare-one/cloud-and-saas-findings/manage-findings/).

### Pause an integration

1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **CASB** > **Integrations**.
2. Find the integration you would like to pause and select **Configure**.
3. To stop scanning the application, turn off **Scan for findings**.
4. Select **Save integration**.

You can resume CASB scanning at any time by turning on **Scan for findings**.

### Delete an integration

Warning

When you delete an integration, all keys and OAuth data will be deleted. This means you cannot restore a deleted integration or its scanned data.

1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **CASB** > **Integrations**.
2. Find the integration you would like to delete and select **Configure**.
3. Select **Disenroll**.

To resume scanning the integration for findings, you will need to [add the integration](#add-an-integration) again.
