---
title: Email Security · Cloudflare Zero Trust docs
description: You can now generate on-demand security reports directly from the
  Cloudflare dashboard. This new feature provides a comprehensive overview of
  your email security posture, making it easier than ever to demonstrate the
  value of Cloudflare’s Email Security to executives and other decision makers.
lastUpdated: 2025-07-07T17:31:26.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/changelog/email-security/
  md: https://developers.cloudflare.com/cloudflare-one/changelog/email-security/index.md
---

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/email-security-cf1.xml)

## 2025-10-17

**On-Demand Security Report**

You can now generate on-demand security reports directly from the Cloudflare dashboard. This new feature provides a comprehensive overview of your email security posture, making it easier than ever to demonstrate the value of Cloudflare’s Email Security to executives and other decision makers.

These reports offer several key benefits:

* **Executive Summary:** Quickly view the performance of Email Security with a high-level executive summary.
* **Actionable Insights:** Dive deep into trend data, breakdowns of threat types, and analysis of top targets to identify and address vulnerabilities.
* **Configuration Transparency:** Gain a clear view of your policy, submission, and domain configurations to ensure optimal setup.

![Report](https://developers.cloudflare.com/_astro/report.CbkPa8Jt_BRc7y.webp)

This feature is available across the following Email Security packages:

* **Advantage**
* **Enterprise**
* **Enterprise + PhishGuard**

## 2025-09-23

**Invalid Submissions Feedback**

Email Security relies on your submissions to continuously improve our detection models. However, we often receive submissions in formats that cannot be ingested, such as incomplete EMLs, screenshots, or text files.

To ensure all customer feedback is actionable, we have launched two new features to manage invalid submissions sent to our team and user [submission aliases](https://developers.cloudflare.com/cloudflare-one/email-security/phish-submissions/#submission-addresses):

* **Email Notifications:** We now automatically notify users by email when they provide an invalid submission, educating them on the correct format. To disable notifications, go to **[Settings](https://one.dash.cloudflare.com/?to=/:account/email-security/settings)** > **Invalid submission emails** and turn the feature off.

![EmailSec-Invalid-Submissions-Toggle](https://developers.cloudflare.com/_astro/EmailSec-Invalid-Submissions-Toggle.DXjbR6aX_Z1aqqxR.webp)

* **Invalid Submission dashboard:** You can quickly identify which users need education to provide valid submissions so Cloudflare can provide continuous protection.

![EmailSec-Invalid-Submissions-Dashboard](https://developers.cloudflare.com/_astro/EmailSec-Invalid-Submissions-Dashboard.zuf1on2n_Z1M2oP7.webp)

Learn more about this feature on [invalid submissions](https://developers.cloudflare.com/cloudflare-one/email-security/email-monitoring/search-email/#invalid-submissions).

This feature is available across these Email Security packages:

* **Advantage**
* **Enterprise**
* **Enterprise + PhishGuard**

## 2025-09-11

**Regional Email Processing for Germany, India, or Australia**

We’re excited to announce that Email Security customers can now choose their preferred mail processing location directly from the UI when onboarding a domain. This feature is available for the following onboarding methods: **MX**, **BCC**, and **Journaling**.

#### What’s new

Customers can now select where their email is processed. The following regions are supported:

* **Germany**
* **India**
* **Australia**

Global processing remains the default option, providing flexibility to meet both compliance requirements or operational preferences.

#### How to use it

When onboarding a domain with MX, BCC, or Journaling:

1. Select the desired processing location (Germany, India, or Australia).
2. The UI will display updated processing addresses specific to that region.
3. For MX onboarding, if your domain is managed by Cloudflare, you can automatically update MX records directly from the UI.

#### Availability

This feature is available across these Email Security packages:

* **Advantage**
* **Enterprise**
* **Enterprise + PhishGuard**

#### What’s next

We’re expanding the list of processing locations to match our [Data Localization Suite (DLS)](https://developers.cloudflare.com/data-localization/) footprint, giving customers the broadest set of regional options in the market without the complexity of self-hosting.

## 2025-09-01

**Updated Email Security roles**

To provide more granular controls, we refined the [existing roles](https://developers.cloudflare.com/cloudflare-one/roles-permissions/#email-security-roles) for Email Security and launched a new Email Security role as well.

All Email Security roles no longer have read or write access to any of the other Zero Trust products:

* **Email Configuration Admin**
* **Email Integration Admin**
* **Email Security Read Only**
* **Email Security Analyst**
* **Email Security Policy Admin**
* **Email Security Reporting**

To configure [Data Loss Prevention (DLP)](https://developers.cloudflare.com/cloudflare-one/email-security/outbound-dlp/) or [Remote Browser Isolation (RBI)](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/setup/clientless-browser-isolation/#set-up-clientless-web-isolation), you now need to be an admin for the Zero Trust dashboard with the **Cloudflare Zero Trust** role.

Also through customer feedback, we have created a new additive role to allow **Email Security Analyst** to create, edit, and delete Email Security policies, without needing to provide access via the **Email Configuration Admin** role. This role is called **Email Security Policy Admin**, which can read all settings, but has write access to [allow policies](https://developers.cloudflare.com/cloudflare-one/email-security/detection-settings/allow-policies/), [trusted domains](https://developers.cloudflare.com/cloudflare-one/email-security/detection-settings/trusted-domains/), and [blocked senders](https://developers.cloudflare.com/cloudflare-one/email-security/detection-settings/blocked-senders/).

This feature is available across these Email Security packages:

* **Advantage**
* **Enterprise**
* **Enterprise + PhishGuard**

## 2025-08-07

**Expanded Email Link Isolation**

When you deploy MX or Inline, not only can you apply email link isolation to suspicious links in all emails (including benign), you can now also apply email link isolation to all links of a specified disposition. This provides more flexibility in controlling user actions within emails.

For example, you may want to deliver suspicious messages but isolate the links found within them so that users who choose to interact with the links will not accidentally expose your organization to threats. This means your end users are more secure than ever before.

![Expanded Email Link Isolation Configuration](https://developers.cloudflare.com/_astro/expanded-link-actions.DziIg6E8_Z1KKbw8.webp)

To isolate all links within a message based on the disposition, select **Settings** > **Link Actions** > **View** and select **Configure**. As with other other links you isolate, an interstitial will be provided to warn users that this site has been isolated and the link will be recrawled live to evaluate if there are any changes in our threat intel. Learn more about this feature on [Configure link actions](https://developers.cloudflare.com/cloudflare-one/email-security/detection-settings/configure-link-actions/).

This feature is available across these Email Security packages:

* **Enterprise**
* **Enterprise + PhishGuard**

## 2025-05-15

**Open email attachments with Browser Isolation**

You can now safely open email attachments to view and investigate them.

What this means is that messages now have a **Attachments** section. Here, you can view processed attachments and their classifications (for example, *Malicious*, *Suspicious*, *Encrypted*). Next to each attachment, a **Browser Isolation** icon allows your team to safely open the file in a **clientless, isolated browser** with no risk to the analyst or your environment.

![Attachment-RBI](https://developers.cloudflare.com/_astro/Attachment-RBI.U9Dp8dJO_ySprI.webp)

To use this feature, you must:

* Enable **Clientless Web Isolation** in your Zero Trust settings.
* Have **Browser Isolation (BISO)** seats assigned.

For more details, refer to our [setup guide](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/setup/clientless-browser-isolation/).

Some attachment types may not render in Browser Isolation. If there is a file type that you would like to be opened with Browser Isolation, reach out to your Cloudflare contact.

This feature is available across these Email Security packages:

* **Advantage**
* **Enterprise**
* **Enterprise + PhishGuard**

## 2025-05-08

**Open email links with Browser Isolation**

You can now safely open links in emails to view and investigate them.

![Open links with Browser Isolation](https://developers.cloudflare.com/_astro/investigate-links.pYbpGkt5_E8W6p.webp)

From **Investigation**, go to **View details**, and look for the **Links identified** section. Next to each link, the Cloudflare dashboard will display an **Open in Browser Isolation** icon which allows your team to safely open the link in a clientless, isolated browser with no risk to the analyst or your environment. Refer to [Open links](https://developers.cloudflare.com/cloudflare-one/email-security/email-monitoring/search-email/#open-links) to learn more about this feature.

To use this feature, you must:

* Enable **Clientless Web Isolation** in your Zero Trust settings.
* Have **Browser Isolation (BISO)** seats assigned.

For more details, refer to our [setup guide](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/setup/clientless-browser-isolation/).

This feature is available across these Email Security packages:

* **Advantage**
* **Enterprise**
* **Enterprise + PhishGuard**

## 2025-04-01

**CASB and Email Security**

With Email Security, you get two free CASB integrations.

Use one SaaS integration for Email Security to sync with your directory of users, take actions on delivered emails, automatically provide EMLs for reclassification requests for clean emails, discover CASB findings and more.

With the other integration, you can have a separate SaaS integration for CASB findings for another SaaS provider.

Refer to [Add an integration](https://developers.cloudflare.com/cloudflare-one/integrations/cloud-and-saas/#add-an-integration) to learn more about this feature.

![CASB-EmailSecurity](https://developers.cloudflare.com/_astro/CASB-EmailSecurity.B1wd9be2_Z1qI0fQ.webp)

This feature is available across these Email Security packages:

* **Enterprise**
* **Enterprise + PhishGuard**

## 2025-03-01

**Use Logpush for Email Security detections**

You can now send detection logs to an endpoint of your choice with Cloudflare Logpush.

Filter logs matching specific criteria you have set and select from over 25 fields you want to send. When creating a new Logpush job, remember to select **Email security alerts** as the dataset.

![logpush-detections](https://developers.cloudflare.com/_astro/Logpush-Detections.Dc5tHta3_Zr7mfa.webp)

For more information, refer to [Enable detection logs](https://developers.cloudflare.com/cloudflare-one/insights/logs/enable-logs/#enable-detection-logs).

This feature is available across these Email Security packages:

* **Enterprise**
* **Enterprise + PhishGuard**

## 2025-02-27

**Check status of Email Security or Area 1**

Concerns about performance for Email Security or Area 1? You can now check the operational status of both on the [Cloudflare Status page](https://www.cloudflarestatus.com/).

For Email Security, look under **Cloudflare Sites and Services**.

* **Dashboard** is the dashboard for Cloudflare, including Email Security
* **Email Security (Zero Trust)** is the processing of email
* **API** are the Cloudflare endpoints, including the ones for Email Security

For Area 1, under **Cloudflare Sites and Services**:

* **Area 1 - Dash** is the dashboard for Cloudflare, including Email Security
* **Email Security (Area1)** is the processing of email
* **Area 1 - API** are the Area 1 endpoints

![Status-page](https://developers.cloudflare.com/_astro/Status-Page.DcFJ1286_2uqBex.webp)

This feature is available across these Email Security packages:

* **Advantage**
* **Enterprise**
* **Enterprise + PhishGuard**

## 2025-02-25

**Use DLP Assist for M365**

Cloudflare Email Security customers who have Microsoft 365 environments can quickly deploy an Email DLP (Data Loss Prevention) solution for free.

Simply deploy our add-in, create a DLP policy in Cloudflare, and configure Outlook to trigger behaviors like displaying a banner, alerting end users before sending, or preventing delivery entirely.

Refer to [Outbound Data Loss Prevention](https://developers.cloudflare.com/cloudflare-one/email-security/outbound-dlp/) to learn more about this feature.

In GUI alert:

![DLP-Alert](https://developers.cloudflare.com/_astro/DLP-Alert.5s-fbKn3_1ALITN.webp)

Alert before sending:

![DLP-Pop-up](https://developers.cloudflare.com/_astro/DLP-Pop-up.0gkYy7o5_1vABF7.webp)

Prevent delivery:

![DLP-Blocked](https://developers.cloudflare.com/_astro/DLP-Blocked.CmQkGrnM_ZBxTWo.webp)

This feature is available across these Email Security packages:

* **Enterprise**
* **Enterprise + PhishGuard**

## 2025-02-07

**Open email links with Security Center**

You can now investigate links in emails with Cloudflare Security Center to generate a report containing a myriad of technical details: a phishing scan, SSL certificate data, HTTP request and response data, page performance data, DNS records, what technologies and libraries the page uses, and more.

![Open links in Security Center](https://developers.cloudflare.com/_astro/Open-Links-Security-Center.b-LJU4YB_xe9E.webp)

From **Investigation**, go to **View details**, and look for the **Links identified** section. Select **Open in Security Center** next to each link. **Open in Security Center** allows your team to quickly generate a detailed report about the link with no risk to the analyst or your environment.

For more details, refer to [Open links](https://developers.cloudflare.com/cloudflare-one/email-security/email-monitoring/search-email/#open-links).

This feature is available across these Email Security packages:

* **Advantage**
* **Enterprise**
* **Enterprise + PhishGuard**

## 2024-12-19

**Escalate user submissions**

After you triage your users' submissions (that are machine reviewed), you can now escalate them to our team for reclassification (which are instead human reviewed). User submissions from the submission alias, PhishNet, and our API can all be escalated.

![Escalate](https://developers.cloudflare.com/_astro/Escalate.CwXPIyM3_1C9J30.webp)

From **Reclassifications**, go to **User submissions**. Select the three dots next to any of the user submissions, then select **Escalate** to create a team request for reclassification. The Cloudflare dashboard will then show you the submissions on the **Team Submissions** tab.

Refer to [User submissions](https://developers.cloudflare.com/cloudflare-one/email-security/email-monitoring/search-email/#user-submissions) to learn more about this feature.

This feature is available across these Email Security packages:

* **Advantage**
* **Enterprise**
* **Enterprise + PhishGuard**

## 2024-12-19

**Increased transparency for phishing email submissions**

You now have more transparency about team and user submissions for phishing emails through a **Reclassification** tab in the Zero Trust dashboard.

Reclassifications happen when users or admins [submit a phish](https://developers.cloudflare.com/cloudflare-one/email-security/phish-submissions/) to Email Security. Cloudflare reviews and - in some cases - reclassifies these emails based on improvements to our machine learning models.

This new tab increases your visibility into this process, allowing you to view what submissions you have made and what the outcomes of those submissions are.

![Use the Reclassification area to review submitted phishing emails](https://developers.cloudflare.com/_astro/reclassifications-tab.yDgtjG51_Z9zOJU.webp)

## 2024-11-07

**Use Logpush for Email Security user actions**

You can now send user action logs for Email Security to an endpoint of your choice with Cloudflare Logpush.

Filter logs matching specific criteria you have set or select from multiple fields you want to send. For all users, we will log the date and time, user ID, IP address, details about the message they accessed, and what actions they took.

When creating a new Logpush job, remember to select **Audit logs** as the dataset and filter by:

* **Field**: `"ResourceType"`
* **Operator**: `"starts with"`
* **Value**: `"email_security"`.

![Logpush-user-actions](https://developers.cloudflare.com/_astro/Logpush-User-Actions.D14fWgmq_Z1FGUyR.webp)

For more information, refer to [Enable user action logs](https://developers.cloudflare.com/cloudflare-one/insights/logs/enable-logs/#enable-user-action-logs).

This feature is available across all Email Security packages:

* **Enterprise**
* **Enterprise + PhishGuard**

## 2024-12-19

**Email Security expanded folder scanning**

Microsoft 365 customers can now choose to scan all folders or just the inbox when deploying via the Graph API.

## 2024-08-06

**Email Security is live**

Email Security is now live under Zero Trust.

## 2024-08-06

**Microsoft Graph API deployment.**

Customers using Microsoft Office 365 can set up Email Security via Microsoft Graph API.
