---
title: Access Changelog · Cloudflare Zero Trust docs
description: Review recent changes to Cloudflare Access.
lastUpdated: 2025-10-24T20:47:24.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/changelog/access/
  md: https://developers.cloudflare.com/cloudflare-one/changelog/access/index.md
---

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/access.xml)

## 2025-09-22

**Access Remote Desktop Protocol (RDP) destinations securely from your browser — now generally available!**

[Browser-based RDP](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/rdp/rdp-browser/) with [Cloudflare Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/) is now generally available for all Cloudflare customers. It enables secure, remote Windows server access without VPNs or RDP clients.

Since we announced our [open beta](https://developers.cloudflare.com/changelog/access/#2025-06-30), we've made a few improvements:

* Support for targets with IPv6.
* Support for [Magic WAN](https://developers.cloudflare.com/magic-wan/) and [WARP Connector](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/warp-connector/) as on-ramps.
* More robust error messaging on the login page to help you if you encounter an issue.
* Worldwide keyboard support. Whether your day-to-day is in Portuguese, Chinese, or something in between, your browser-based RDP experience will look and feel exactly like you are using a desktop RDP client.
* Cleaned up some other miscellaneous issues, including but not limited to enhanced support for Entra ID accounts and support for usernames with spaces, quotes, and special characters.

As a refresher, here are some benefits browser-based RDP provides:

* **Control how users authenticate to internal RDP resources** with single sign-on (SSO), multi-factor authentication (MFA), and granular access policies.
* **Record who is accessing which servers and when** to support regulatory compliance requirements and to gain greater visibility in the event of a security event.
* **Eliminate the need to install and manage software on user devices**. You will only need a web browser.
* **Reduce your attack surface** by keeping your RDP servers off the public Internet and protecting them from common threats like credential stuffing or brute-force attacks.

![Example of a browser-based RDP Access application](https://developers.cloudflare.com/_astro/browser-based-rdp-access-app.BNXce1JL_1NEtce.webp)

To get started, refer to [Connect to RDP in a browser](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/rdp/rdp-browser/).

## 2025-08-26

**Manage and restrict access to internal MCP servers with Cloudflare Access**

You can now control who within your organization has access to internal MCP servers, by putting internal MCP servers behind [Cloudflare Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/).

[Self-hosted applications](https://developers.cloudflare.com/cloudflare-one/access-controls/ai-controls/linked-apps/) in Cloudflare Access now support OAuth for MCP server authentication. This allows Cloudflare to delegate access from any self-hosted application to an MCP server via OAuth. The OAuth access token authorizes the MCP server to make requests to your self-hosted applications on behalf of the authorized user, using that user's specific permissions and scopes.

For example, if you have an MCP server designed for internal use within your organization, you can configure Access policies to ensure that only authorized users can access it, regardless of which MCP client they use. Support for internal, self-hosted MCP servers also works with MCP server portals, allowing you to provide a single MCP endpoint for multiple MCP servers. For more on MCP server portals, read the [blog post](https://blog.cloudflare.com/zero-trust-mcp-server-portals/) on the Cloudflare Blog.

## 2025-08-26

**MCP server portals**\
![MCP server portal](https://developers.cloudflare.com/_astro/mcp-server-portal.BOKqTCoI_ZIxF0P.webp)

An [MCP server portal](https://developers.cloudflare.com/cloudflare-one/access-controls/ai-controls/mcp-portals/) centralizes multiple Model Context Protocol (MCP) servers onto a single HTTP endpoint. Key benefits include:

* **Streamlined access to multiple MCP servers**: MCP server portals support both unauthenticated MCP servers as well as MCP servers secured using any third-party or custom OAuth provider. Users log in to the portal URL through Cloudflare Access and are prompted to authenticate separately to each server that requires OAuth.
* **Customized tools per portal**: Admins can tailor an MCP portal to a particular use case by choosing the specific tools and prompt templates that they want to make available to users through the portal. This allows users to access a curated set of tools and prompts — the less external context exposed to the AI model, the better the AI responses tend to be.
* **Observability**: Once the user's AI agent is connected to the portal, Cloudflare Access logs the indiviudal requests made using the tools in the portal.

This is available in an open beta for all customers across all plans! For more information check out our [blog](https://blog.cloudflare.com/zero-trust-mcp-server-portals/) for this release.

## 2025-08-15

**SFTP support for SSH with Cloudflare Access for Infrastructure**

[SSH with Cloudflare Access for Infrastructure](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/ssh/ssh-infrastructure-access/) now supports SFTP. It is compatible with SFTP clients, such as Cyberduck.

## 2025-08-14

**Cloudflare Access Logging supports the Customer Metadata Boundary (CMB)**

Cloudflare Access logs now support the [Customer Metadata Boundary (CMB)](https://developers.cloudflare.com/data-localization/metadata-boundary/). If you have configured the CMB for your account, all Access logging will respect that configuration.

Note

For EU CMB customers, the logs will not be stored by Access and will appear as empty in the dashboard. EU CMB customers should utilize [Logpush](https://developers.cloudflare.com/logs/logpush/) to retain their Access logging, if desired.

## 2025-07-01

**Access RDP securely from your browser — now in open beta**

[Browser-based RDP](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/rdp/rdp-browser/) with [Cloudflare Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/) is now available in open beta for all Cloudflare customers. It enables secure, remote Windows server access without VPNs or RDP clients.

With browser-based RDP, you can:

* **Control how users authenticate to internal RDP resources** with single sign-on (SSO), multi-factor authentication (MFA), and granular access policies.
* **Record who is accessing which servers and when** to support regulatory compliance requirements and to gain greater visibility in the event of a security event.
* **Eliminate the need to install and manage software on user devices**. You will only need a web browser.
* **Reduce your attack surface** by keeping your RDP servers off the public Internet and protecting them from common threats like credential stuffing or brute-force attacks.

![Example of a browsed-based RDP Access application](https://developers.cloudflare.com/_astro/browser-based-rdp-access-app.BNXce1JL_1NEtce.webp)

To get started, see [Connect to RDP in a browser](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/rdp/rdp-browser/).

## 2025-06-05

**Cloudflare One Analytics Dashboards and Exportable Access Report**

Cloudflare One now offers powerful new analytics dashboards to help customers easily discover available insights into their application access and network activity. These dashboards provide a centralized, intuitive view for understanding user behavior, application usage, and security posture.

!\[Cloudflare One Analytics Dashboards]\(\~/assets/images/changelog/cloudflare-one/Analytics Dashboards.png)

Additionally, a new exportable access report is available, allowing customers to quickly view high-level metrics and trends in their application access. A **preview** of the report is shown below, with more to be found in the report:

![Cloudflare One Analytics Dashboards](https://developers.cloudflare.com/_astro/access-report.C744W7JR_Td5Jj.webp)

Both features are accessible in the Cloudflare [Zero Trust dashboard](https://one.dash.cloudflare.com/), empowering organizations with better visibility and control.

## 2025-05-16

**New Access Analytics in the Cloudflare One Dashboard**

A new Access Analytics dashboard is now available to all Cloudflare One customers. Customers can apply and combine multiple filters to dive into specific slices of their Access metrics. These filters include:

* Logins granted and denied
* Access events by type (SSO, Login, Logout)
* Application name (Salesforce, Jira, Slack, etc.)
* Identity provider (Okta, Google, Microsoft, onetimepin, etc.)
* Users (`chris@cloudflare.com`, `sally@cloudflare.com`, `rachel@cloudflare.com`, etc.)
* Countries (US, CA, UK, FR, BR, CN, etc.)
* Source IP address
* App type (self-hosted, Infrastructure, RDP, etc.)

![Access Analytics](https://developers.cloudflare.com/_astro/accessanalytics.DYXgwZCl_cA6SI.webp)

To access the new overview, log in to your Cloudflare [Zero Trust dashboard](https://one.dash.cloudflare.com/) and find Analytics in the side navigation bar.

## 2025-04-21

**Access bulk policy tester**

The [Access bulk policy tester](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/policy-management/#test-all-policies-in-an-application) is now available in the Cloudflare Zero Trust dashboard. The bulk policy tester allows you to simulate Access policies against your entire user base before and after deploying any changes. The policy tester will simulate the configured policy against each user's last seen identity and device posture (if applicable).

![Example policy tester](https://developers.cloudflare.com/_astro/example-policy-tester.DCY8hQvx_ZVibzJ.webp)

## 2025-04-09

**Cloudflare Zero Trust SCIM User and Group Provisioning Logs**

[Cloudflare Zero Trust SCIM provisioning](https://developers.cloudflare.com/cloudflare-one/team-and-resources/users/scim) now has a full audit log of all create, update and delete event from any SCIM Enabled IdP. The [SCIM logs](https://developers.cloudflare.com/cloudflare-one/insights/logs/scim-logs/) support filtering by IdP, Event type, Result and many more fields. This will help with debugging user and group update issues and questions.

SCIM logs can be found on the Zero Trust Dashboard under **Logs** -> **SCIM provisioning**.

![Example SCIM Logs](https://developers.cloudflare.com/_astro/example-scim-log.Bv5Zqckh_Z1GHFvk.webp)

## 2025-03-03

**New SAML and OIDC Fields and SAML transforms for Access for SaaS**

[Access for SaaS applications](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/http-apps/saas-apps/) now include more configuration options to support a wider array of SaaS applications.

**SAML and OIDC Field Additions**

OIDC apps now include:

* Group Filtering via RegEx
* OIDC Claim mapping from an IdP
* OIDC token lifetime control
* Advanced OIDC auth flows including hybrid and implicit flows

![OIDC field additions](https://developers.cloudflare.com/_astro/oidc-claims.2di8l9Lv_ZOEc1S.webp)

SAML apps now include improved SAML attribute mapping from an IdP.

![SAML field additions](https://developers.cloudflare.com/_astro/saml-attribute-statements.CW45j5Qi_ZjcQ8E.webp)

**SAML transformations**

SAML identities sent to Access applications can be fully customized using JSONata expressions. This allows admins to configure the precise identity SAML statement sent to a SaaS application.

![Configured SAML statement sent to application](https://developers.cloudflare.com/_astro/transformation-box.DyKn-DdN_7LzOj.webp)

## 2025-01-15

**Export SSH command logs with Access for Infrastructure using Logpush**

Availability

Only available on Enterprise plans.

Cloudflare now allows you to send SSH command logs to storage destinations configured in [Logpush](https://developers.cloudflare.com/logs/logpush/), including third-party destinations. Once exported, analyze and audit the data as best fits your organization! For a list of available data fields, refer to the [SSH logs dataset](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/ssh_logs/).

To set up a Logpush job, refer to [Logpush integration](https://developers.cloudflare.com/cloudflare-one/insights/logs/logpush/).

## 2024-10-01

**Eliminate long-lived credentials and enhance SSH security with Cloudflare Access for Infrastructure**

Organizations can now eliminate long-lived credentials from their SSH setup and enable strong multi-factor authentication for SSH access, similar to other Access applications, all while generating access and command logs.

SSH with [Access for Infrastructure](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/non-http/infrastructure-apps/) uses short-lived SSH certificates from Cloudflare, eliminating SSH key management and reducing the security risks associated with lost or stolen keys. It also leverages a common deployment model for Cloudflare One customers: [WARP-to-Tunnel](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/ssh/ssh-warp-to-tunnel/).

SSH with Access for Infrastructure enables you to:

* **Author fine-grained policy** to control who may access your SSH servers, including specific ports, protocols, and SSH users.
* **Monitor infrastructure access** with Access and SSH command logs, supporting regulatory compliance and providing visibility in case of security breach.
* **Preserve your end users' workflows.** SSH with Access for Infrastructure supports native SSH clients and does not require any modifications to users’ SSH configs.

![Example of an infrastructure Access application](https://developers.cloudflare.com/_astro/infrastructure-app.BhpJOgxs_Z1Ixiie.webp)

To get started, refer to [SSH with Access for Infrastructure](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/ssh/ssh-infrastructure-access/).

## 2025-02-12

**Access policies support filtering**

You can now filter Access policies by their action, selectors, rule groups, and assigned applications.

## 2025-02-11

**Private self-hosted applications and reusable policies GA**

[Private self-hosted applications](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/non-http/self-hosted-private-app/) and [reusable Access policies](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/policy-management/) are now generally available (GA) for all customers.

## 2025-01-21

**Access Applications support private hostnames/IPs and reusable Access policies.**

Cloudflare Access self-hosted applications can now be defined by [private IPs](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/non-http/self-hosted-private-app/), [private hostnames](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/non-http/self-hosted-private-app/) (on port 443) and [public hostnames](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/http-apps/self-hosted-public-app/). Additionally, we made Access policies into their own object which can be reused across multiple applications. These updates involved significant updates to the overall Access dashboard experience. The updates will be slowly rolled out to different customer cohorts. If you are an Enterprise customer and would like early access, reach out to your account team.

## 2025-01-15

**Logpush for SSH command logs**

Enterprise customers can now use Logpush to export SSH command logs for Access for Infrastructure targets.

## 2024-12-04

**SCIM GA for Okta and Microsoft Entra ID**

Cloudflare's SCIM integrations with [Okta](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/okta/#synchronize-users-and-groups) and [Microsoft Entra ID](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/entra-id/#synchronize-users-and-groups) (formerly AzureAD) are now out of beta and generally available (GA) for all customers. These integrations can be used for Access and Gateway policies and Zero Trust user management. Note: This GA release does not include [Dashboard SSO SCIM](https://developers.cloudflare.com/fundamentals/account/account-security/scim-setup/) support.

## 2024-10-23

**SSH with Access for Infrastructure**

Admins can now use [Access for Infrastructure](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/ssh/ssh-infrastructure-access/) to manage privileged access to SSH servers. Access for Infrastructure provides improved control and visibility over who accessed what service and what they did during their SSH session. Access for Infrastructure also eliminates the risk and overhead associated with managing SSH keys by using short-lived SSH certificates to access SSH servers.

## 2024-08-26

**Reduce automatic seat deprovisioning minimum to 1 month, down from 2 months.**

Admins can now configure Zero Trust seats to [automatically expire](https://developers.cloudflare.com/cloudflare-one/team-and-resources/users/seat-management/#enable-seat-expiration) after 1 month of user inactivity. The previous minimum was 2 months.

## 2024-06-06

**Scalability improvements to the App Launcher**

Applications now load more quickly for customers with a large number of applications or complex policies.

## 2024-04-28

**Add option to bypass CORS to origin server**

Access admins can [defer all CORS enforcement to their origin server](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/http-apps/authorization-cookie/cors/#bypass-options-requests-to-origin) for specific Access applications.

## 2024-04-15

**Zero Trust User identity audit logs**

All user identity changes via SCIM or Authentication events are logged against a user's registry identity.

## 2024-02-22

**Access for SaaS OIDC Support**

Access for SaaS applications can be setup with OIDC as an authentication method. OIDC and SAML 2.0 are now both fully supported.

## 2024-02-22

**WARP as an identity source for Access**

Allow users to log in to Access applications with their WARP session identity. Users need to reauthenticate based on default session durations. WARP authentication identity must be turned on in your device enrollment permissions and can be enabled on a per application basis.

## 2023-12-20

**Unique Entity IDs in Access for SaaS**

All new Access for SaaS applications have unique Entity IDs. This allows for multiple integrations with the same SaaS provider if required. The unique Entity ID has the application audience tag appended. Existing apps are unchanged.

## 2023-12-15

**Default relay state support in Access for SaaS**

Allows Access admins to set a default relay state on Access for SaaS apps.

## 2023-09-15

**App launcher supports tags and filters**

Access admins can now tag applications and allow users to filter by those tags in the App Launcher.

## 2023-09-15

**App launcher customization**

Allow Access admins to configure the App Launcher page within Zero Trust.

## 2023-09-15

**View active Access user identities in the dashboard and API**

Access admins can now view the full contents of a user's identity and device information for all active application sessions.

## 2023-09-08

**Custom OIDC claims for named IdPs**

Access admins can now add custom claims to the existing named IdP providers. Previously this was locked to the generic OIDC provider.

## 2023-08-02

**Azure AD authentication contexts**

Support Azure AD authentication contexts directly in Access policies.

## 2023-06-23

**Custom block pages for Access applications**

Allow Access admins to customize the block pages presented by Access to end users.
