---
title: Area 1 · Cloudflare Zero Trust docs
description: Cloudflare Area 1 is an email security platform that protects your
  organization's inbox from phishing, spam, and other malicious messages. This
  guide covers how to configure Area 1 as a SAML application in Cloudflare Zero
  Trust.
lastUpdated: 2025-10-23T20:06:36.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/access-controls/applications/http-apps/saas-apps/area-1/
  md: https://developers.cloudflare.com/cloudflare-one/access-controls/applications/http-apps/saas-apps/area-1/index.md
---

Access to Area 1

Beginning October 1, 2025, access and support for Email Security (formerly Area 1) will only be available through the Cloudflare dashboard. Your Email Security protection will not change, but you will no longer be able to access the Area 1 dashboard or send support requests to `@area1security.com` email addresses. For help accessing the Cloudflare dashboard, reach out to <successteam@cloudflare.com>.

[Cloudflare Area 1](https://www.cloudflare.com/products/zero-trust/email-security/) is an email security platform that protects your organization's inbox from phishing, spam, and other malicious messages. This guide covers how to configure Area 1 as a SAML application in Cloudflare Zero Trust.

## Prerequisites

* An [identity provider](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/) configured in Cloudflare Zero Trust
* Admin access to your Area 1 account
* Your user's email in Area 1 matches their email in Zero Trust

## 1. Add Area 1 to Zero Trust

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Access** > **Applications**.

2. Select **Add an application**.

3. Select **SaaS**.

4. In the **Application** field, enter `Area 1` and select **Area 1**. (Area 1 is not currently listed in the default drop-down menu.)

5. Enter the following values for your application configuration:

   | | |
   | - | - |
   | **Entity ID** | `https://horizon.area1security.com` |
   | **Assertion Consumer Service URL** | `https://horizon.area1security.com/api/users/saml` |
   | **Name ID Format** | *Email* |

6. Configure [Access policies](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/) for the application.

7. Save the application.

## 2. Configure SSO for Area 1

Finally, you will need to configure Area 1 to allow users to log in through Cloudflare Access.

1. In your [Area 1 portal](https://horizon.area1security.com/), go to **Settings** > **SSO**.

2. Turn on **Single Sign On**.

3. (Optional) To require users to sign in through Access, set **SSO Enforcement** to *All*. When SSO is enforced, users will no longer be able to sign in with their Area 1 credentials.

4. In **SAML SSO Domain**, enter `<your-team-name>.cloudflareaccess.com`.

5. Get your Metadata XML file:

   1. In Zero Trust, copy the **SSO Endpoint** for your application.

      ![Copy SSO settings for a SaaS application from Zero Trust](https://developers.cloudflare.com/_astro/saas-sso-endpoint.ubdoNRaM_1EMtvX.webp)

   2. In a new browser tab, paste the **SSO Endpoint** and append `/saml-metadata` to the end of the URL. For example, `https://<your-team-name>.cloudflareaccess.com/cdn-cgi/access/sso/saml/<app-id>/saml-metadata`.

   3. Copy the resulting metadata.

6. Return to the Area 1 portal and paste the metadata into **Metadata XML**.

   ![Configure SSO in the Area 1 portal](https://developers.cloudflare.com/_astro/area1-sso-config.DWq80iDZ_ZeOMPf.webp)

7. Select **Update Settings**.

If you added the application to your App Launcher, you can test the integration by going to `<your-team-name>.cloudflareaccess.com`.
