---
title: Workers for Platforms now supports Static Assets · Changelog
description: Workers for Platforms customers can now serve static assets for
  User Workers directly from Cloudflare's global edge
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-01-31-workers-platforms-static-assets/
  md: https://developers.cloudflare.com/changelog/2025-01-31-workers-platforms-static-assets/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Workers for Platforms now supports Static Assets

Jan 31, 2025

[Workers for Platforms](https://developers.cloudflare.com/cloudflare-for-platforms/workers-for-platforms/)

Workers for Platforms customers can now attach static assets (HTML, CSS, JavaScript, images) directly to User Workers, removing the need to host separate infrastructure to serve the assets.

This allows your platform to serve entire front-end applications from Cloudflare's global edge, utilizing caching for fast load times, while supporting dynamic logic within the same Worker. Cloudflare automatically scales its infrastructure to handle high traffic volumes, enabling you to focus on building features without managing servers.

#### What you can build

**Static Sites:** Host and serve HTML, CSS, JavaScript, and media files directly from Cloudflare's network, ensuring fast loading times worldwide. This is ideal for blogs, landing pages, and documentation sites because static assets can be efficiently cached and delivered closer to the user, reducing latency and enhancing the overall user experience.

**Full-Stack Applications:** Combine asset hosting with Cloudflare Workers to power dynamic, interactive applications. If you're an e-commerce platform, you can serve your customers' product pages and run inventory checks from within the same Worker.

* JavaScript

  ```js
  export default {
    async fetch(request, env) {
      const url = new URL(request.url);


      // Check real-time inventory
      if (url.pathname === "/api/inventory/check") {
        const product = url.searchParams.get("product");
        const inventory = await env.INVENTORY_KV.get(product);
        return new Response(inventory);
      }


      // Serve static assets (HTML, CSS, images)
      return env.ASSETS.fetch(request);
    },
  };
  ```

* TypeScript

  ```ts
  export default {
    async fetch(request, env) {
      const url = new URL(request.url);


      // Check real-time inventory
      if (url.pathname === '/api/inventory/check') {
        const product = url.searchParams.get('product');
        const inventory = await env.INVENTORY_KV.get(product);
        return new Response(inventory);
      }


      // Serve static assets (HTML, CSS, images)
      return env.ASSETS.fetch(request);
    }
  };
  ```

**Get Started:** Upload static assets using the Workers for Platforms API or Wrangler. For more information, visit our [Workers for Platforms documentation.](https://developers.cloudflare.com/cloudflare-for-platforms/workers-for-platforms/configuration/static-assets/)
