---
title: Sales tax · Cloudflare Billing docs
description: To adhere to tax laws in specific geographies, Cloudflare collects
  sales tax on sales of our services based on your billing address.
lastUpdated: 2025-09-12T21:09:09.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/billing/sales-tax/
  md: https://developers.cloudflare.com/billing/sales-tax/index.md
---

To adhere to tax laws in specific geographies, Cloudflare collects sales tax on sales of our services based on your billing address.

To avoid unwanted charges, ensure your billing address and payment method are accurate within your Cloudflare account.

Note

Cloudflare customers in a sponsorship program (i.e. [Project Athenian](https://www.cloudflare.com/athenian/), [Project Galileo](https://www.cloudflare.com/galileo/), [Cloudflare for Campaigns](https://www.cloudflare.com/campaigns/)) are not charged sales tax.

## US State sales tax

In the US, sales tax requirements are computed based on the 9-digit postal code of the address on file for your Cloudflare account. Note to customers in Maryland: On July 1, 2025, Maryland began charging a tax on some technology services, including some provided by Cloudflare.

### Filing for US sales tax exemption

Cloudflare is required by law to maintain documentation of tax-exempt sales. If you or your company are exempt from paying sales tax, email <exemptioncertificates@cloudflare.com> from an email address associated with your Cloudflare account and provide one of the following forms of tax-exempt documentation:

* Resale certificate
* Multi-state tax exemption certificate
* State sales tax exemption certificate
* Partial sales tax exemption certificate

After your exemption is validated, tax-exempt status is added to your Cloudflare account information. Cloudflare invoices do not contain sales tax for the duration your exemption is valid.

## Russia (VAT)

Foreign e-services suppliers are required by law to collect taxes on the supply of e-services to Russian customers. Cloudflare customers with Russian billing addresses are charged a 20% flat tax rate based on their billing address on file.

[Update your billing information](https://developers.cloudflare.com/billing/update-billing-info/) with your Russian VAT ID to include it in your Cloudflare invoices.

Note

There is no tax exemption for Russian customers.

## Singapore (GST)

Cloudflare adds 9% sales tax for individuals and non-GST registered business customers within Singapore. GST-registered customers are required to self access GST. Refunds are not issued for taxed customers that were missing the GST Registration Number within their Cloudflare account.

Contact <billing@cloudflare.com> with any questions.

## Taiwan (VAT)

Cloudflare collects VAT on all pay-as-you-go customers in Taiwan. The eGUI Invoice ID and eGUI Code are shown in the Cloudflare dashboard and are required to retrieve an invoice from the Taiwan government.

## Japan (CT)

Cloudflare Inc. is currently registered in Japan as of October 1st, 2023. Due to some constraints, Cloudflare will be only able to start collecting tax from PAYGO customers on April 1st, 2024.

## Canada

All **NON-GST Registered** Customers who are located in Canada are required by law to pay tax.

Note

Anyone who provides a GST ID is exempt, no other exceptions.

## Malaysia (VAT)

All customers who are located in Malaysia are required to pay tax. This includes companies located or whose management is located in Malaysia. **Non-Residents of Malaysia are exempt.**

If there is no invoice, there is no VAT. VAT is calculated on the amount billed.

## South Africa (VAT)

All customers who are located in South Africa are required to pay tax. This includes companies located or whose management is located in South Africa. **Non-Residents of South Africa are exempt.**

If there is no invoice, there is no VAT. VAT is calculated on the amount billed.

## India (GST)

Cloudflare Inc. is registered for Goods and Services Tax (GST) purposes in India as of October 1st, 2023.

An email communication, in both English and Hindi, was shared at the end of October and the beginning of November with all Indian customers to inform and request them to update addresses and GST IDs accordingly.

Make sure that your complete address and GST ID is properly updated on your account to avoid additional charges.

## Kenya (VAT)

Cloudflare will issue tax invoices and add VAT at the 16% standard rate on top of the amounts charged beginning on October 1st, 2023.

You may update your VAT registration number in your account profile.

Reach out to Cloudflare via email <indirect_tax@cloudflare.com> if you have any tax related concerns or questions.
