---
title: Enhance Transform Rules with JWT claims · Cloudflare API Shield docs
description: You can forward information from a JSON Web Token (JWT) to the
  origin in a header by creating Transform Rules using claims that Cloudflare
  has verified via the JSON Web Token.
lastUpdated: 2025-09-26T21:09:24.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/api-shield/security/jwt-validation/transform-rules/
  md: https://developers.cloudflare.com/api-shield/security/jwt-validation/transform-rules/index.md
---

You can forward information from a [JSON Web Token (JWT)](https://developers.cloudflare.com/api-shield/security/jwt-validation/) to the origin in a header by creating [Transform Rules](https://developers.cloudflare.com/rules/transform/) using claims that Cloudflare has verified via the JSON Web Token.

Claims are available through the `http.request.jwt.claims` firewall fields.

For example, the following expression will extract the user claim from a token processed by the token configuration with `TOKEN_CONFIGURATION_ID`:

```txt
lookup_json_string(http.request.jwt.claims["<TOKEN_CONFIGURATION_ID>"][0], "claim_name")
```

Refer to [Configure JWT validation](https://developers.cloudflare.com/api-shield/security/jwt-validation/api/) for more information about creating a token configuration.

## Create a Transform Rule

As an example, to send the `x-send-jwt-claim-user` request header to the origin, you must create a Transform Rule:

1. In the Cloudflare dashboard, go to the **Rules overview** page.

   [Go to **Overview**](https://dash.cloudflare.com/?to=/:account/:zone/rules/overview)

2. Select **Create rule** > **Request Header Transform Rules**.

3. Enter a rule name and a filter expression, if applicable.

4. Choose **Set dynamic**.

5. Set the header name to `x-send-jwt-claim-user`.

6. Set the value to:

   ```txt
   lookup_json_string(http.request.jwt.claims["<TOKEN_CONFIGURATION_ID>"][0], "claim_name")
   ```

   `<TOKEN_CONFIGURATION_ID>` is your token configuration ID found in JWT validation and `claim_name` is the JWT claim you want to add to the header.
